﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VeteransAffairs.Registries.BusinessAHOBPR
{
    /// <summary>
    /// Tests if a registrant is eligible to be in the AHOBPR program.
    /// </summary>
   public  class AHOBPREligibilityValidator : EligibilityValidator
    {
        public AHOBPREligibilityValidator(List<string> names, List<string> codes, DateRange dates) : base(names, codes, dates) { }

        protected override bool DatesAreEligible(DateRange deployment)
        {
            return (deployment.Start >= EligibleDates.Start || deployment.End >= EligibleDates.Start);
        }
        protected override bool DatesAreEligible(REGISTRANT_DEPLOYMENT deployment)
        {
            return DatesAreEligible(new DateRange((DateTime)deployment.DEPLOYMENT_START_DATE, (DateTime)deployment.DEPLOYMENT_END_DATE));
        }
    }
}
